package fr.asip.cps3.exemple.vues.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;

import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;

/**
 * Classe permettant de modliser la bote de dialogue de saisie des codes pour le recyclage
 */
public class SaisieRecyclage  {

	JFrame fenetre;
	protected String titre;
	protected JDialog d;
	protected JLabel libelleConformiteCodeDeblocage;
	protected JLabel libelleConformiteCodePorteur;
	private JLabel libelleNbEssais;	
	protected JLabel libellePUK;
	protected JLabel libellePIN1;
	protected JLabel libellePIN2;
	protected JPasswordField codeDeblocage;
	protected JPasswordField codePorteur1;
	protected JPasswordField codePorteur2;
	protected JPanel panel;
	protected JButton btnValider;
	protected JButton btnAnnuler;
	protected int choixUtilisateur;
	protected char[] puk = null;
	protected char[] pin1 = null;
	protected char[] pin2 = null;
	
	private Color niveauCouleur;
	public static final Color NIVEAU_OK = new Color(70,128,37) /* Vert */;
	public static final Color NIVEAU_ATTENTION = new Color(173,145,33) /* Orange */;
	public static final Color NIVEAU_CRITIQUE = Color.RED;
	
	/**
	 * Constructeur
	 * @param fenetre fentre parente de la dialog
	 * @param titre titre de la dialog
	 * @param conformiteCodeDeblocage Etat de conformit du code de dblocage
	 * @param conformiteCodePorteur Etat de conformit du code porteur
	 * @param numeroSerieCarte Numro de srie de la carte
	 * @param texteNbEssais texte d'avertissement pour le nombre d'essais
	 * @param niveauCouleur couleur du texte d'avertissement pour le nombre d'essais
	 */
	public SaisieRecyclage(JFrame fenetre, String titre, String conformiteCodeDeblocage, String conformiteCodePorteur, String numeroSerieCarte, String texteNbEssais, Color niveauCouleur) {
		
		this.fenetre = fenetre;
		this.titre = titre+" "+numeroSerieCarte;
		d = new JDialog(fenetre);
		libellePUK = new JLabel("Entrez le code de dblocage : ");
		libellePIN1 = new JLabel("Entrez le nouveau code porteur : ");
		libellePIN2 = new JLabel("R-entrez le nouveau code porteur : ");
		if(conformiteCodePorteur != null) {
			libelleConformiteCodePorteur = new JLabel(conformiteCodePorteur);
			libelleConformiteCodePorteur.setForeground(Color.RED);
			libelleConformiteCodePorteur.setFont(new Font("Arial",Font.BOLD,11));
		}
		if(conformiteCodeDeblocage != null) {
			libelleConformiteCodeDeblocage = new JLabel(conformiteCodeDeblocage);
			libelleConformiteCodeDeblocage.setForeground(Color.RED);
			libelleConformiteCodeDeblocage.setFont(new Font("Arial",Font.BOLD,11));
		}
		this.niveauCouleur = niveauCouleur;
		libelleNbEssais = new JLabel(texteNbEssais);
		codeDeblocage = new JPasswordField(32);
		codePorteur1 = new JPasswordField(32);
		codePorteur2 = new JPasswordField(32);
		btnValider = new JButton("Valider");
		btnAnnuler = new JButton("Annuler");
		
	}

	/**
	 * Affiche la dialog
	 */
	public void affiche() {
		
		panel = new JPanel();
		
		// Cration du layout
		panel.setBorder(new EmptyBorder(0, 0, 0, 0));
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        
		libelleNbEssais.setForeground(niveauCouleur);
		libelleNbEssais.setFont(new Font("Arial",Font.ITALIC,11));
        
        // Ajout des composants
        GridBagHelper g = new GridBagHelper(panel);
        
        int i = 0;
        if(libelleConformiteCodePorteur != null) {
        	g.ajoute(libelleConformiteCodePorteur, EcranUtil.styleLibelleDialogLigneEntiere, 0, 0, 1, 2);
        	i++;
        }
        
        g.ajoute(libelleNbEssais, EcranUtil.styleLibelleDialogLigneEntiere, i, 0, 1, 2);

        if(libelleConformiteCodeDeblocage != null) {
        	g.ajoute(libelleConformiteCodeDeblocage, EcranUtil.styleLibelleDialogLigneEntiere, i+1, 0, 1, 2);
        	i++;
        }        
        
        g.ajoute(libellePUK, EcranUtil.styleLibelleSaisie, i+1, 0, 1, 1);
        g.ajoute(codeDeblocage, EcranUtil.styleChampTexteSaisie, i+1, 1, 1, 1);
        g.ajoute(libellePIN1, EcranUtil.styleLibelleSaisie, i+2, 0, 1, 1);
        g.ajoute(codePorteur1, EcranUtil.styleChampTexteSaisie, i+2, 1, 1, 1);
        g.ajoute(libellePIN2, EcranUtil.styleLibelleSaisie, i+3, 0, 1, 1);
        g.ajoute(codePorteur2, EcranUtil.styleChampTexteSaisie, i+3, 1, 1, 1);      
        g.ajoute(btnValider, EcranUtil.styleBoutonDialogValider, i+4, 0, 1, 1);
        g.ajoute(btnAnnuler, EcranUtil.styleBoutonDialogAnnuler, i+4, 1, 1, 1);

	    d.getContentPane().add(panel,BorderLayout.CENTER);
		d.setTitle(titre);
		d.setModal(true);
		d.pack();
		
		// centrage de la dialog
        Rectangle r = fenetre.getBounds();
        int x = r.x + (r.width - d.getSize().width)/2;
        int y = r.y + (r.height - d.getSize().height)/2;
        d.setLocation(x, y);
		
		ActionListener ecouteur = new ActionListener(){
			public void actionPerformed(ActionEvent ae){
				
				if(ae.getSource() == btnAnnuler) {
					choixUtilisateur = -1;
				} else {
					puk = codeDeblocage.getPassword();
					pin1 = codePorteur1.getPassword();
					pin2 = codePorteur2.getPassword();					
					choixUtilisateur = 1;
				}
				d.dispose();
			}
		};

		btnValider.addActionListener(ecouteur);
		btnAnnuler.addActionListener(ecouteur);
		
		d.setVisible(true);		
				
		
	}
	
	/**
	 * Accesseur
	 * @return Code dblocage
	 */
	public char[] getCodeDeblocage(){
		return puk;
	}

	/**
	 * Accesseur
	 * @return Code porteur 1
	 */
	public char[] getCodePorteur1(){
		return pin1;
	}
	
	/**
	 * Accesseur
	 * @return Code porteur 1
	 */
	public char[] getCodePorteur2(){
		return pin2;
	}		
	
	/**
	 * Accesseur
	 * @return Choix utilisateur
	 */
	public int getChoixUtilisateur(){
		return choixUtilisateur;
	}	
	
}